/**
 * Migration Configuration
 *
 * Copy this file to config.js and update with your actual database credentials.
 * NEVER commit config.js to version control!
 */

module.exports = {
  // SQL Server (C# Backend) Configuration
  sqlServer: {
    user: 'your_sqlserver_username',
    password: 'your_sqlserver_password',
    server: 'localhost', // or your SQL Server host
    database: 'PrezpVR_Dev', // or your database name
    options: {
      encrypt: true, // Use encryption for Azure
      trustServerCertificate: true, // Change to false in production
      enableArithAbort: true,
      connectionTimeout: 30000,
      requestTimeout: 30000,
    },
    pool: {
      max: 10,
      min: 0,
      idleTimeoutMillis: 30000,
    },
  },

  // MySQL (Node.js Backend) Configuration
  mysql: {
    host: 'localhost',
    user: 'root',
    password: 'your_mysql_password',
    database: 'immblend',
    port: 3306,
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0,
  },
};
