const database = require("@database");
const utils = require("@utils");

const logoutAuthentication = async (req, res) => {
  try {
    // req.user is set by tokenvalidator middleware
    const { ugid, device_id } = req.user;

    if (!device_id) {
      return utils.responseSnippet(
        res,
        400,
        "No device information found in token.",
        null
      );
    }

    // Set device as offline (logged out)
    const updated = await database("user_devices")
      .where({
        ugid: ugid,
        device_id: device_id,
      })
      .update({
        is_online: false,
        last_active: database.fn.now(),
      });

    if (updated === 0) {
      console.warn(`Device not found for logout: ugid=${ugid}, device_id=${device_id}`);
      // Still return success - token will be invalid anyway
    }

    console.log(`✅ User logged out successfully: ugid=${ugid}, device_id=${device_id}`);

    utils.responseSnippet(
      res,
      200,
      "Logout successful. Your session has been terminated.",
      {
        logged_out: true,
      }
    );
  } catch (error) {
    console.error("Logout error:", error);
    utils.catchErrorHandlerSnippet(res, error, __dirname);
  }
};

module.exports = logoutAuthentication;
