/**
 * Get Presentations Controller
 *
 * Returns all presentations for the authenticated user
 * - Retrieves from database ordered by upload date (newest first)
 * - Returns presentation metadata (id, name, size, dates)
 */

const database = require("@database");
const utils = require("@utils");

const getPresentations = async (req, res) => {
  try {
    // Get user UGID from token
    const { ugid } = req.user;

    // Fetch all presentations for the user
    const presentations = await database("presentation_pdf")
      .where({ ugid })
      .select("id", "presentation_name")
      .orderBy("id", "desc");

    return utils.responseSnippet(
      res,
      200,
      "Presentations retrieved successfully",
      presentations
    );
  } catch (error) {
    console.error("Get presentations error:", error);
    return utils.catchErrorHandlerSnippet(res, error, __dirname);
  }
};

module.exports = getPresentations;
