const database = require("@database");
const utils = require("@utils");

const blockUserManagement = async (req, res) => {
  try {
    const { ugid } = req.params;

    const user = await database("user_data").where({ ugid }).first();

    if (!user) {
      return utils.responseSnippet(res, 404, "User not found.", null);
    }

    const isAdmin = await database("admin_list")
      .where({ ugid })
      .first();

    if (isAdmin) {
      return utils.responseSnippet(
        res,
        403,
        "Cannot block admin user.",
        null
      );
    }

    const isBlocked = await database("user_blocked_list")
      .where({ ugid })
      .first();

    if (isBlocked) {
      await database("user_blocked_list").where({ ugid }).delete();

      utils.responseSnippet(
        res,
        200,
        "User unblocked successfully.",
        null
      );
    } else {
      await database("user_blocked_list").insert({ ugid });
      utils.responseSnippet(
        res,
        200,
        "User blocked successfully.",
        null
      );
    }
  } catch (error) {
    console.error("Block user error:", error);
    utils.catchErrorHandlerSnippet(
      res,
      error,
      "block_user.user_management.js"
    );
  }
};

module.exports = blockUserManagement;
