const database = require("@database");
const utils = require("@utils");

const deleteUserManagement = async (req, res) => {
  try {
    const { ugid } = req.params;

    const user = await database("user_data").where({ ugid }).first();

    if (!user) {
      return utils.responseSnippet(res, 404, "User not found.", null);
    }

    const isAdmin = await database("admin_list")
      .where({ ugid })
      .first();

    if (isAdmin) {
      return utils.responseSnippet(
        res,
        403,
        "Cannot delete admin user.",
        null
      );
    }

    await database.transaction(async (trx) => {
      await trx("user_access").where({ ugid }).delete();
      await trx("user_devices").where({ ugid }).delete();
      await trx("user_blocked_list").where({ ugid }).delete();
      await trx("user_data").where({ ugid }).delete();
    });

    utils.responseSnippet(
      res,
      200,
      "User deleted successfully.",
      null
    );
  } catch (error) {
    console.error("Delete user error:", error);
    utils.catchErrorHandlerSnippet(
      res,
      error,
      "delete_user.user_management.js"
    );
  }
};

module.exports = deleteUserManagement;
