const database = require("@database");
const utils = require("@utils");

const getUserManagement = async (req, res) => {
  try {
    const { ugid } = req.params;

    const user = await database("user_data")
      .select(
        "user_data.ugid",
        "user_data.username",
        "user_data.name",
        "user_data.email",
        "user_data.time_joined",
        "user_data.language",
        "user_data.last_ip",
        "user_access.authorized_modules"
      )
      .leftJoin("user_access", "user_data.ugid", "user_access.ugid")
      .where("user_data.ugid", ugid)
      .first();

    if (!user) {
      return utils.responseSnippet(res, 404, "User not found.", null);
    }

    const isBlocked = await database("user_blocked_list")
      .where({ ugid })
      .first();

    const isAdmin = await database("admin_list")
      .where({ ugid })
      .first();

    const formattedUser = {
      ...user,
      is_blocked: !!isBlocked,
      is_admin: !!isAdmin,
      authorized_modules: user.authorized_modules
        ? user.authorized_modules.split(",")
        : [],
    };

    utils.responseSnippet(
      res,
      200,
      "User retrieved successfully.",
      formattedUser
    );
  } catch (error) {
    console.error("Get user error:", error);
    utils.catchErrorHandlerSnippet(
      res,
      error,
      "get_user.user_management.js"
    );
  }
};

module.exports = getUserManagement;
