const database = require("@database");
const utils = require("@utils");

const updateUserManagement = async (req, res) => {
  try {
    const { ugid } = req.params;
    const { name, is_admin, authorized_modules } = req.body;

    const user = await database("user_data").where({ ugid }).first();

    if (!user) {
      return utils.responseSnippet(res, 404, "User not found.", null);
    }

    await database.transaction(async (trx) => {
      // Update user data
      await trx("user_data").where({ ugid }).update({ name });

      // If is_admin is provided, update admin status
      if (typeof is_admin !== "undefined") {
        const existingAdmin = await trx("admin_list")
          .where({ ugid })
          .first();

        if (is_admin && !existingAdmin) {
          await trx("admin_list").insert({ ugid });
        } else if (!is_admin && existingAdmin) {
          await trx("admin_list").where({ ugid }).delete();
        }
      }

      // If authorized_modules is provided, update access
      if (authorized_modules) {
        await trx("user_access")
          .where({ ugid })
          .update({
            authorized_modules: authorized_modules.join(","),
          });
      }
    });

    utils.responseSnippet(res, 200, "User updated successfully.", {
      ugid,
      name,
      is_admin,
      authorized_modules,
    });
  } catch (error) {
    console.error("Update user error:", error);
    utils.catchErrorHandlerSnippet(
      res,
      error,
      "update_user.user_management.js"
    );
  }
};

module.exports = updateUserManagement;
