const jwt = require("jsonwebtoken");
const config = require("@config");
const utils = require("@utils");
const database = require("@database");

const accessvalidator = (requiredModule) => {
  return async (req, res, next) => {
    try {
      const authHeader = req.headers.authorization;

      if (!authHeader || !authHeader.startsWith("Bearer ")) {
        return utils.responseSnippet(
          res,
          401,
          "Authentication required",
          null
        );
      }

      const token = authHeader.split(" ")[1];
      const decodedToken = jwt.verify(token, config.session.secret);
      const ugid = decodedToken.ugid;

      if (!ugid) {
        return utils.responseSnippet(
          res,
          401,
          "Authentication required",
          null
        );
      }

      const userAccess = await database("user_access")
        .select("authorized_modules")
        .where({ ugid })
        .first();

      if (!userAccess) {
        return utils.responseSnippet(
          res,
          403,
          "Access information not found",
          null
        );
      }

      const { authorized_modules } = userAccess;

      if (authorized_modules === "all") {
        return next();
      }

      const modules = authorized_modules
        .split(",")
        .map((module) => module.trim());

      if (modules.includes(requiredModule)) {
        return next();
      }

      return utils.responseSnippet(
        res,
        403,
        `Access to ${requiredModule} module denied`,
        null
      );
    } catch (err) {
      if (err.name === "JsonWebTokenError") {
        return utils.responseSnippet(
          res,
          401,
          "Invalid token. Please login again.",
          null
        );
      }

      if (err.name === "TokenExpiredError") {
        return utils.responseSnippet(
          res,
          401,
          "Token expired. Please login again.",
          null
        );
      }

      console.error(`Module access middleware error: ${err.message}`);
      return utils.responseSnippet(
        res,
        500,
        "Error checking module access",
        null
      );
    }
  };
};

module.exports = accessvalidator;
