const jwt = require("jsonwebtoken");
const config = require("@config");
const utils = require("@utils");
const database = require("@database");

const isadmin = () => {
  return async (req, res, next) => {
    try {
      const authHeader = req.headers.authorization;

      if (!authHeader || !authHeader.startsWith("Bearer ")) {
        return utils.responseSnippet(
          res,
          401,
          "Authentication required",
          null
        );
      }

      const token = authHeader.split(" ")[1];
      const decodedToken = jwt.verify(token, config.session.secret);
      const ugid = decodedToken.ugid;

      if (!ugid) {
        return utils.responseSnippet(
          res,
          401,
          "Authentication required",
          null
        );
      }

      const adminUser = await database("admin_list")
        .where({ ugid })
        .first();

      if (adminUser) {
        return next();
      }

      return utils.responseSnippet(
        res,
        403,
        "Access denied: Admin privileges required",
        null
      );
    } catch (err) {
      if (err.name === "JsonWebTokenError") {
        return utils.responseSnippet(
          res,
          401,
          "Invalid token. Please login again.",
          null
        );
      }

      if (err.name === "TokenExpiredError") {
        return utils.responseSnippet(
          res,
          401,
          "Token expired. Please login again.",
          null
        );
      }

      console.error(`Admin check middleware error: ${err.message}`);
      return utils.responseSnippet(
        res,
        500,
        "Error checking admin access",
        null
      );
    }
  };
};

module.exports = isadmin;
