const { express, Joi } = require("@packages");
const { schemavalidator, tokenvalidator } = require("@middlewares");
const config = require("@config");
const authenticationRouter = express.Router();

authenticationRouter.post(
  "/codegenerator",
  schemavalidator.SchemaValidator(
    "body",
    Joi.object({
      email: Joi.string().label("Email").email().max(30).required(),
      language: Joi.string().label("Language").valid('en', 'de').optional(),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/authentication/code_generator.authentication.js")(req, res);
  }
);

authenticationRouter.get(
  "/verify/:code/:email",
  schemavalidator.SchemaValidator(
    "params",
    Joi.object({
      code: Joi.string().label("Code").min(1).required(),
      email: Joi.string().label("Email").email().max(30).required(),
    }).unknown(false)
  ),
  (req, res) => {
    require("../controllers/authentication/code_verify.authentication.js")(req, res);
  }
);

authenticationRouter.get(
  "/info",
  schemavalidator.SchemaValidator("query", Joi.object({}).unknown(false)),
  tokenvalidator,
  (req, res) => {
    require("../controllers/authentication/get_info.authentication.js")(req, res);
  }
);

authenticationRouter.post(
  "/logout",
  schemavalidator.SchemaValidator("body", Joi.object({}).unknown(false)),
  tokenvalidator,
  (req, res) => {
    require("../controllers/authentication/logout.authentication.js")(req, res);
  }
);

module.exports = authenticationRouter;