// Imports
const utils = require("@utils");
const config = require("@config");

const emailSender = (
  emailReciever,
  emailSubject,
  emailContent,
  locale
) => {
  const nodemailer = require("nodemailer"); // Imports nodemailer module
  const config = require("@config"); // Load config Object. Note: Config depends dynamically on NODE_ENV definition.

  // Refrence: https://nodemailer.com/about/
  // Defining a promise to handle rejects and resolves
  return new Promise(async (resolve, reject) => {
    console.log(
      `[${new Date().toISOString()}] Email config: host=${
        config.email.host
      }, port=${config.email.port}, secure=${
        config.email.secure
      }, user=${config.email.user}`
    );

    let transporterDetails = nodemailer.createTransport({
      host: config.email.host,
      port: config.email.port,
      secure: config.email.secure,
      auth: {
        user: config.email.user,
        pass: config.email.pass,
      },
    });
    let senderName = `"${config.projectName}" <${config.email.user}>`; // Use configured email

    console.log(
      `[${new Date().toISOString()}] Sending email to: ${emailReciever}, subject: ${emailSubject}`
    );

    let emailContentInfo = transporterDetails.sendMail(
      {
        from: senderName, // Use the conditionally set sender name
        to: emailReciever,
        subject: emailSubject,
        html: emailContent,
      },
      function (error, info) {
        // Callback function to handle promise status => Reject or Resolve
        if (error) {
          console.error(
            `[${new Date().toISOString()}] Email send error to ${emailReciever}:`,
            error
          );
          reject(error);
        } else {
          console.log(
            `[${new Date().toISOString()}] Email sent successfully to ${emailReciever}, messageId: ${
              info.messageId
            }`
          );
          resolve(true);
        }
      }
    );
  });
};

module.exports = emailSender;
