// Packages
const fs = require("fs");
const path = require("path");

// Imports
const utils = require("@utils");
const config = require("@config");

const errorLogFileGenerator = (errorMessage, fileName) => {
  const time = new Date();
  const timeForFileName = `${time.getFullYear()}${
    time.getMonth() + 1
  }${time.getDate()}${time.getHours()}${time.getMinutes()}${time.getSeconds()}${time.getMilliseconds()}`;
  const fileNameAndPathConfig = path.format({
    dir: path.join(__dirname, "../../../logs/errors"),
    base: `err_${timeForFileName}` + ".txt",
  });
  const content = `The error occured in '${fileName}', here's the error message: ${errorMessage}`;
  try {
    fs.writeFileSync(fileNameAndPathConfig, content);
  } catch (err) {
    console.error(err);
  }
};

module.exports = errorLogFileGenerator;
