// Imports
const utils = require("@utils");
const config = require("@config");

const getClientIP = (req) => {
  // Replace optional chaining operator with traditional conditional check
  const forwardedIp = req.headers["x-forwarded-for"]
    ? req.headers["x-forwarded-for"].split(",")[0]
    : null;

  return (
    req.headers["cf-connecting-ip"] || // Cloudflare specific
    req.headers["x-real-ip"] || // Nginx proxy
    forwardedIp || // First IP in forwarding chain
    req.connection.remoteAddress // Direct connection
  );
};

module.exports = getClientIP;
