/**
 * Check Speech Speed Scores in Database
 */

require('module-alias/register');
const database = require('@database');

async function checkSpeechSpeedScores() {
  try {
    console.log('\n====================================================');
    console.log('🔍 SPEECH SPEED SCORE CHECK');
    console.log('====================================================\n');

    // Get sessions with scores
    const sessions = await database('presentation_session')
      .select('id', 'session_name', 'speech_speed_score', 'overall_score', 'pauses_score', 'words_per_minute')
      .orderBy('recording_date', 'desc')
      .limit(10);

    console.log('Recent sessions with scores:\n');
    sessions.forEach(s => {
      console.log(`ID: ${s.id}`);
      console.log(`  Name: ${s.session_name}`);
      console.log(`  Speech Speed Score: ${s.speech_speed_score} ${s.speech_speed_score === 0 ? '⚠️ ZERO!' : ''}`);
      console.log(`  Words Per Minute: ${s.words_per_minute}`);
      console.log(`  Overall Score: ${s.overall_score}`);
      console.log(`  Pauses Score: ${s.pauses_score}`);
      console.log('---');
    });

    // Check for sessions with 0 speech_speed_score but valid WPM
    const problematicSessions = await database('presentation_session')
      .select('id', 'session_name', 'speech_speed_score', 'words_per_minute')
      .where('speech_speed_score', 0)
      .whereNotNull('words_per_minute')
      .where('words_per_minute', '>', 0);

    if (problematicSessions.length > 0) {
      console.log('\n⚠️ PROBLEMATIC SESSIONS (score=0 but have WPM):\n');
      problematicSessions.forEach(s => {
        console.log(`  ID: ${s.id} | ${s.session_name} | WPM: ${s.words_per_minute}`);
      });
    }

    await database.destroy();
  } catch (error) {
    console.error('❌ Error:', error);
    await database.destroy();
  }
}

checkSpeechSpeedScores();