const database = require("@database");
const utils = require("@utils");
const { v4: uuidv4 } = require("uuid");

const registerUserManagement = async (req, res) => {
  try {
    const { email, name, authorized_modules, is_admin } = req.body;

    const existingUser = await database("user_data")
      .where({ email })
      .first();

    if (existingUser) {
      return utils.responseSnippet(
        res,
        400,
        "User already exists.",
        null
      );
    }

    const ugid = uuidv4();
    const username = email.split("@")[0];

    await database.transaction(async (trx) => {
      await trx("user_data").insert({
        username,
        name,
        ugid,
        email,
        time_joined: database.fn.now(),
        language: "en",
      });

      await trx("user_access").insert({
        ugid,
        authorized_modules: authorized_modules.join(","),
      });

      if (is_admin) {
        await trx("admin_list").insert({ ugid });
      }
    });

    utils.responseSnippet(res, 201, "User registered successfully.", {
      ugid,
      email,
      name,
      username,
      authorized_modules,
      is_admin,
    });
  } catch (error) {
    console.error("Register user error:", error);
    utils.catchErrorHandlerSnippet(
      res,
      error,
      "register_user.user_management.js"
    );
  }
};

module.exports = registerUserManagement;
