// Imports
const responseSnippet = require("./responsesnippet.util");
const errorLogFileGenerator = require("./errorlogfilegenerator.util");
const config = require("@config");

const catchErrorHandlerSnippet = (res, err, filename) => {
  console.log(err);
  errorLogFileGenerator(err, filename.split("/").pop());
  responseSnippet(
    res,
    500,
    "A problem happened while processing your request!",
    null
  );
};

module.exports = catchErrorHandlerSnippet;
