// Packages
const jwt = require("jsonwebtoken");

// Imports
const utils = require("@utils");
const config = require("@config");

const decodeDataFromToken = (req, propToBeDecoded) => {
  return new Promise((resolve, reject) => {
    const bearerHeader = req.headers.authorization;

    try {
      if (!propToBeDecoded) {
        reject("No propToBeDecoded is provided!");
        console.error("No propToBeDecoded is provided!");
        return;
      }

      const [scheme, credentials] = bearerHeader.split(" ");

      if (!/^Bearer$/i.test(scheme)) {
        reject("Token doesn't have valid type!");
        return;
      }

      const decodedJwtToken = jwt.verify(credentials, config.token.jwt_secret_key);

      if (Array.isArray(propToBeDecoded)) {
        resolve({
          ugid: decodedJwtToken.ugid,
          deviceId: decodedJwtToken.device_id,
        });
      } else {
        resolve(decodedJwtToken[propToBeDecoded]);
      }
    } catch (err) {
      reject(err);
    }
  });
};

module.exports = decodeDataFromToken;
